/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.world.level.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.mapper.mapperbase.world.level.block.CustomBlock;
import tv.mapper.mapperbase.world.level.block.ToolTiers;
import tv.mapper.mapperbase.world.level.block.ToolTypes;
import tv.mapper.roadstuff.world.item.BrushItem;
import tv.mapper.roadstuff.world.level.block.state.properties.EnumPaintColor;

public class PaintBucketBlock
extends CustomBlock
implements SimpleWaterloggedBlock {
    private static final int MAX_PAINT = 8;
    public static final IntegerProperty PAINT = IntegerProperty.m_61631_((String)"paint", (int)0, (int)8);
    public static final EnumProperty<EnumPaintColor> COLOR = EnumProperty.m_61587_((String)"color", EnumPaintColor.class);
    public static final DirectionProperty DIRECTION = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape PAINT_BUCKET = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);

    public PaintBucketBlock(BlockBehaviour.Properties properties, ToolTypes tool) {
        super(properties, tool);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PAINT, (Comparable)Integer.valueOf(0))).m_61124_(COLOR, (Comparable)((Object)EnumPaintColor.WHITE))).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public PaintBucketBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier) {
        super(properties, tool, tier);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PAINT, (Comparable)Integer.valueOf(0))).m_61124_(COLOR, (Comparable)((Object)EnumPaintColor.WHITE))).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return PAINT_BUCKET;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return PAINT_BUCKET;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PAINT, COLOR, DIRECTION, WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        FluidState FluidState2 = context.m_43725_().m_6425_(blockpos);
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PAINT, (Comparable)Integer.valueOf(stack.m_41783_().m_128451_("paint")))).m_61124_(COLOR, (Comparable)((Object)EnumPaintColor.values()[stack.m_41783_().m_128451_("color")]))).m_61124_((Property)DIRECTION, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.m_76152_() == Fluids.f_76193_));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PAINT, (Comparable)Integer.valueOf(0))).m_61124_(COLOR, (Comparable)((Object)EnumPaintColor.WHITE))).m_61124_((Property)DIRECTION, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.m_76152_() == Fluids.f_76193_));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            player.m_5661_((Component)new TranslatableComponent("roadstuff.message.bucket.underwater"), true);
            return InteractionResult.FAIL;
        }
        ItemStack item = player.m_21120_(hand);
        if (item.m_41720_() instanceof BrushItem) {
            int paint = (Integer)state.m_61143_((Property)PAINT);
            if (paint <= 0) {
                if (!world.f_46443_) {
                    player.m_5661_((Component)new TranslatableComponent("roadstuff.message.bucket.empty"), true);
                }
                return InteractionResult.FAIL;
            }
            if (!item.m_41782_()) {
                item.m_41751_(BrushItem.checkNBT(item));
            }
            if (item.m_41783_().m_128451_("paint") < ((BrushItem)item.m_41720_()).getMaxPaint() && paint > 0 || item.m_41783_().m_128451_("paint") == ((BrushItem)item.m_41720_()).getMaxPaint() && item.m_41783_().m_128451_("color") != ((EnumPaintColor)((Object)state.m_61143_(COLOR))).getId()) {
                if (!world.f_46443_) {
                    if (!player.m_7500_()) {
                        world.m_46597_(pos, (BlockState)state.m_61124_((Property)PAINT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PAINT) - 1)));
                    }
                    item.m_41783_().m_128405_("paint", ((BrushItem)item.m_41720_()).getMaxPaint());
                    item.m_41783_().m_128405_("color", ((EnumPaintColor)((Object)state.m_61143_(COLOR))).getId());
                    world.m_5594_(null, pos, SoundEvents.f_11780_, SoundSource.BLOCKS, 0.8f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (item.m_41720_() instanceof DyeItem && !world.f_46443_) {
            DyeItem dye = (DyeItem)item.m_41720_();
            if ((Integer)state.m_61143_((Property)PAINT) != 0) {
                if (dye.m_41089_() == DyeColor.WHITE && state.m_61143_(COLOR) == EnumPaintColor.YELLOW) {
                    player.m_5661_((Component)new TranslatableComponent("roadstuff.message.bucket.yellow"), true);
                    return InteractionResult.FAIL;
                }
                if (dye.m_41089_() == DyeColor.YELLOW && state.m_61143_(COLOR) == EnumPaintColor.WHITE) {
                    player.m_5661_((Component)new TranslatableComponent("roadstuff.message.bucket.white"), true);
                    return InteractionResult.FAIL;
                }
            }
            if ((Integer)state.m_61143_((Property)PAINT) >= 8) {
                player.m_5661_((Component)new TranslatableComponent("roadstuff.message.bucket.full"), true);
                return InteractionResult.FAIL;
            }
            if ((Integer)state.m_61143_((Property)PAINT) < 8) {
                if (dye.m_41089_() == DyeColor.WHITE) {
                    world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)PAINT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PAINT) + 1))).m_61124_(COLOR, (Comparable)((Object)EnumPaintColor.WHITE)));
                } else if (dye.m_41089_() == DyeColor.YELLOW) {
                    world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)PAINT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PAINT) + 1))).m_61124_(COLOR, (Comparable)((Object)EnumPaintColor.YELLOW)));
                }
                if (dye.m_41089_() == DyeColor.WHITE || dye.m_41089_() == DyeColor.YELLOW) {
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                    world.m_5594_(null, pos, SoundEvents.f_11783_, SoundSource.BLOCKS, 0.8f, 0.9f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_ && !player.m_7500_()) {
            ItemStack stack = new ItemStack((ItemLike)Item.m_41439_((Block)this));
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("paint", ((Integer)state.m_61143_((Property)PAINT)).intValue());
            nbt.m_128405_("color", ((EnumPaintColor)((Object)state.m_61143_(COLOR))).ordinal());
            stack.m_41751_(nbt);
            ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            itementity.m_32060_();
            world.m_7967_((Entity)itementity);
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return PaintBucketBlock.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public Fluid takeLiquid(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.f_76193_;
        }
        return Fluids.f_76191_;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false && fluidIn == Fluids.f_76193_;
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && fluidStateIn.m_76152_() == Fluids.f_76193_) {
            if (!worldIn.m_5776_()) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.m_186469_(pos, fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public ToolTiers getTier() {
        return this.tier;
    }

    public ToolTypes getTool() {
        return this.tool;
    }

    public ItemStack m_142598_(LevelAccessor p_152719_, BlockPos p_152720_, BlockState p_152721_) {
        return null;
    }

    public Optional<SoundEvent> m_142298_() {
        return null;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)DIRECTION, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)DIRECTION)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)DIRECTION)));
    }
}

